/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.config.client.IHeldLayerSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public class CustomHeldLayer<E extends LivingEntity, M extends EntityModel<E>>
extends LayerRenderer<E, M> {
    private final IHeldLayerSettings config;

    public CustomHeldLayer(IEntityRenderer<E, M> renderer, IHeldLayerSettings config) {
        super(renderer);
        this.config = config;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int light, E entity, float f0, float f1, float f2, float f3, float f4, float f5) {
        ItemStack offHandItem;
        ItemStack mainHandItem;
        boolean useStatic;
        IHeldLayerSettings.Mode mode = this.config.getRenderingMode();
        if (mode == IHeldLayerSettings.Mode.NONE) {
            return;
        }
        boolean rightHanded = entity.func_184591_cq() == HandSide.RIGHT;
        boolean bl = useStatic = mode == IHeldLayerSettings.Mode.STATIC;
        ItemStack itemStack = useStatic ? this.config.getRenderItem() : (mainHandItem = rightHanded ? entity.func_184614_ca() : entity.func_184592_cb());
        ItemStack itemStack2 = useStatic ? ItemStack.field_190927_a : (offHandItem = rightHanded ? entity.func_184592_cb() : entity.func_184614_ca());
        if (!mainHandItem.func_190926_b() || !offHandItem.func_190926_b()) {
            matrix.func_227860_a_();
            EntityModel model = this.func_215332_c();
            if (model.field_217114_e) {
                float scale = 0.5f;
                matrix.func_227861_a_(0.0, 0.75, 0.0);
                matrix.func_227862_a_(scale, scale, scale);
            }
            this.renderItemInArm(entity, mainHandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrix, buffer, light);
            this.renderItemInArm(entity, offHandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrix, buffer, light);
            matrix.func_227865_b_();
        }
    }

    private void renderItemInArm(E entity, ItemStack item, ItemCameraTransforms.TransformType transform, HandSide side, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int light) {
        if (item.func_190926_b()) {
            return;
        }
        matrix.func_227860_a_();
        IHasArm iHasArm = (IHasArm)this.func_215332_c();
        iHasArm.func_225599_a_(side, matrix);
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        boolean leftHanded = side == HandSide.LEFT;
        matrix.func_227861_a_((double)((float)(leftHanded ? -1 : 1) / 16.0f), 0.125, -0.625);
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(entity, item, transform, leftHanded, matrix, typeBuffer, light);
        matrix.func_227865_b_();
    }
}

